import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:play_lab/view/components/buttons/rounded_loading_button.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';
import 'package:play_lab/view/screens/auth/registration/widget/validation_widget.dart';

import '../../../../../constants/my_strings.dart';
import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/util.dart';
import '../../../../../data/controller/auth/auth/forget_password_controller.dart';
import '../../../../../data/repo/auth/login_repo.dart';
import '../../../../../data/services/api_service.dart';
import '../../../../components/app_bar/custom_appbar.dart';
import '../../../../components/auth_image.dart';
import '../../../../components/bg_widget/bg_image_widget.dart';
import '../../../../components/buttons/rounded_button.dart';
import '../../../../components/custom_text_field.dart';
import '../../../../components/from_errors.dart';

class ResetPasswordScreen extends StatefulWidget {
  const ResetPasswordScreen({super.key});

  @override
  State<ResetPasswordScreen> createState() => _ResetPasswordScreenState();
}

class _ResetPasswordScreenState extends State<ResetPasswordScreen> {
  @override
  void initState() {
    MyUtil.changeTheme();

    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(LoginRepo(apiClient: Get.find(), sharedPreferences: Get.find()));
    final controller = Get.put(ForgetPasswordController(loginRepo: Get.find()));
    controller.email = Get.arguments;
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((t) {
      controller.initData();
    });
  }

  @override
  void dispose() {
    Get.find<ForgetPasswordController>().errors.clear();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    Get.find<ForgetPasswordController>().isLoading = false;
    return Stack(
      children: [
        const MyBgWidget(),
        PopScope(
          canPop: false,
          child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: CustomAppBar(title: MyStrings.resetPassword.tr, fromAuth: true),
            body: GetBuilder<ForgetPasswordController>(
              builder: (controller) => SingleChildScrollView(
                padding: const EdgeInsets.symmetric(horizontal: 15),
                child: SizedBox(
                  child: ListView(
                    shrinkWrap: true,
                    children: [
                      SizedBox(height: MediaQuery.of(context).size.height * .07),
                      const AuthImageWidget(),
                      SizedBox(height: MediaQuery.of(context).size.height * .07),
                      Padding(
                        padding: EdgeInsets.symmetric(horizontal: MediaQuery.of(context).size.width * .1, vertical: 8),
                        child: RichText(text: TextSpan(text: MyStrings.resetLabelText.tr, style: const TextStyle(color: MyColor.t2, fontSize: Dimensions.authTextSize)), textAlign: TextAlign.center),
                      ),
                      const SizedBox(height: 40),
                      Column(
                        children: [
                          Focus(
                            onFocusChange: (hasFocus) => controller.changePasswordFocus(hasFocus),
                            child: CustomTextField(
                              fillColor: MyColor.textFiledFillColor,
                              focusNode: controller.passwordFocusNode,
                              nextFocus: controller.confirmPasswordFocusNode,
                              controller: controller.passwordController,
                              hintText: MyStrings.password,
                              isShowSuffixIcon: true,
                              isPassword: true,
                              inputType: TextInputType.text,
                              onChanged: (value) {
                                if (controller.checkPasswordStrength) {
                                  controller.updateValidationList(value);
                                }
                              },
                            ),
                          ),
                          const SizedBox(height: 15),
                          Visibility(
                            visible: controller.hasPasswordFocus && controller.checkPasswordStrength,
                            child: ValidationWidget(list: controller.passwordValidationRules),
                          ),
                          CustomTextField(
                            fillColor: MyColor.textFiledFillColor,
                            inputAction: TextInputAction.done,
                            isPassword: true,
                            hintText: MyStrings.confirmPassword,
                            isShowSuffixIcon: true,
                            onChanged: (value) {},
                            controller: controller.confirmPasswordController,
                          ),
                          const SizedBox(height: 50),
                          RoundedButton(
                            width: 1,
                            isLoading: controller.isLoading,
                            text: MyStrings.submit,
                            press: () {
                              controller.resetPassword();
                            },
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ),
        ),
      ],
    );
  }
}
